#!/bin/sh

q3map="d:/GtkRadiant-1.4/q3map2.exe"
fs_basepath="d:/tenebrae2/Beta"
#fs_game="tenebrae"
fs_game="industri"
maps_dev="d:/tenebrae2/Beta/industri/maps_dev"
maps="d:/tenebrae2/Beta/industri/maps"
game_dir="d:/tenebrae2/Beta"
game_settings="start tenebrae2.exe -game industri -window -developer 1 -condebug -width 640 -height 480 +map"

help () {
	echo "
Usage: $0 mapname [-bounce]

-bounce: use -bounce 4 with the light compile.
 
 Do NOT include the .map extension. The path is defined within the script
"
	exit 1
}

leaked () {
	echo "
 ================================================
   Map has a leak!!
 ================================================"
echo -n "   Stop and fix the leak? (y/n[y])"
read ans

if [ "$ans" = "y" -o "$ans" = "" ]
then
	exit 0
fi

}

if [ "$1" = "" ]
then
	help
fi

echo "
 ================================================
   starting $1 bsp compile `date` 
 ================================================
"
./$q3map -fs_basepath "$fs_basepath" -fs_game "$fs_game" "$maps_dev/$1.map"

if [ -f "$maps_dev/$1.lin" ]
then
	leaked
fi

echo "
 ================================================
   starting $1 vis compile `date`
 ================================================
"
./$q3map -fs_basepath "$fs_basepath" -fs_game "$fs_game" -vis "$maps_dev/$1.bsp"
echo "
 ================================================
   starting $1 light compile `date`
 ================================================
"

if [ "$2" = "-bounce" ] 
then
	./$q3map -fs_basepath "$fs_basepath" -fs_game "$fs_game" -light -deluxe -patchshadows -bounce 4 "$maps_dev/$1.bsp"
else
	./$q3map -fs_basepath "$fs_basepath" -fs_game "$fs_game" -light -deluxe -patchshadows "$maps_dev/$1.bsp"
fi
 

if [ -s "$maps/$1.bsp" ]
then
	mv -fv "$maps/$1.bsp" "$maps/$1.OLD"
fi

mv -fv "$maps_dev/$1.bsp" "$maps/$1.bsp"

echo "
 ================================================
  $1 compile finished `date`
 ================================================"
echo -n "Run map? (y/n[y])"
read ans

if [ "$ans" = "y" -o "$ans" = "" ]
then
	current_dir=`pwd`
	cd "$game_dir"
	cmd /C $game_settings $1
	#./$game_settings $1
	cd "$current_dir"
fi
exit 0

