// lighting.c

#include "light.h"

#define LOGFILENAME "LIGHT.LOG"

/*

NOTES
-----

*/

float		scaledist = 1.0;
float		scalecos = 0.5;
float		rangescale = 0.5;
int	        worldminlight = -1;
int	        worldmaxlight = -1;

byte		*filebase, *file_p, *file_end;

dmodel_t	*bspmodel;
int			bspfileface;	// next surface to dispatch

vec3_t	bsp_origin;

qboolean	extrasamples;
qboolean	nolight;

double		start = 0, end;
FILE		*logfile;

void logvprintf (char *fmt, va_list argptr)
{
	ShowPercent(NULL, 0, -1);

        vprintf (fmt, argptr);
        fflush(stdout);
        vfprintf (logfile, fmt, argptr);
        fflush (logfile);
}

void logprintf (char *fmt, ...)
{
	va_list argptr;

	va_start (argptr, fmt);
	logvprintf (fmt,argptr);
	va_end (argptr);
}

void PrintFinish (void)
{
	char Str[20];

	if (start == 0)
		return;

	end = I_FloatTime ();

	SecToStr((time_t)(end - start + 0.5), Str, true);

	logprintf ("\nElapsed time : %s\n", Str);
	
	fclose(logfile);
}


byte *GetFileSpace (int size)
{
	byte	*buf;
	
	LOCK;
	file_p = (byte *)(((long)file_p + 3)&~3);
	buf = file_p;
	file_p += size;
	UNLOCK;
	if (file_p > file_end)
		Error ("Light data size exceeded, max = %i kbyte", MAX_MAP_LIGHTING / 1024);
	return buf;
}


void LightThread (void *junk)
{
	int			i;
	
	if (NewLine)
		fprintf(logfile, "\n");
	else
		logprintf("\n");

	ShowPercent("Light", 0, 0);

	while (1)
	{
		LOCK;
		i = bspfileface++;
		UNLOCK;
		
		if (i >= numfaces)
		{
			ShowPercent(NULL, 100, 100);
			printf("\n\n");

			return;
		}
		
		ShowPercent(NULL, i, numfaces);

		LightFace (i);
	}
}

/*
=============
LightWorld
=============
*/
void LightWorld (void)
{
	filebase = file_p = dlightdata;
	file_end = filebase + MAX_MAP_LIGHTING;

	RunThreadsOn (LightThread);

	lightdatasize = file_p - filebase;
	
	logprintf ("lightdatasize: %i\n", lightdatasize);
}


/*
==============
ChkArgument
==============
*/
void ChkArgument(char Arg[], char *NextOption)
{
	if (NextOption == NULL)
		Error ("Missing '%s' argument", Arg);
}

/*
========
main

light modelfile
========
*/
int main (int argc, char **argv)
{
	int		i;
	char		source[1024], *Option, *NextOption;

        logfile = fopen (LOGFILENAME, "w");
	logprintf ("----- Light 1.14 ---- Modified by Bengt Jardrup\n\n");

	for (i=1 ; i<argc ; i++)
	{
		Option = argv[i];
		NextOption = i + 1 < argc ? argv[i + 1] : NULL;
		
		if (Option[0] != '-')
			break;
			
		++Option;
		
		if (!stricmp(Option, "extra"))
		{
			extrasamples = true;
			logprintf ("Extra sampling enabled\n");
		}
		else if (!stricmp(Option, "dist"))
		{
			ChkArgument(Option, NextOption);
			scaledist = atof (NextOption);
			i++;
		}
		else if (!stricmp(Option, "range"))
		{
			ChkArgument(Option, NextOption);
			rangescale = atof (NextOption);
			i++;
		}
		else if (!stricmp(Option, "light"))
		{
			ChkArgument(Option, NextOption);
			worldminlight = atoi (NextOption);
			i++;
		}
		else if (!stricmp(Option, "maxlight"))
		{
			ChkArgument(Option, NextOption);
			worldmaxlight = atoi (NextOption);
			i++;
		}
		else if (!stricmp(Option, "nolight"))
		{
			nolight = true;
			logprintf ("Light entities disabled\n");
		}
		else if (!stricmp(Option, "rate"))
		{
			ChkArgument(Option, NextOption);
			sscanf(NextOption, "%d,%d,%d,%d", &SecRate, &PercRate, &NewLine, &TotTime);
			i++;
		}
		else
			Error ("Unknown option '%s'", Option);
	}

	if (i != argc - 1)
		Error ("usage: light [options] bspfile\noptions: -extra -dist[1.0] -range[0.5] -light[0] -maxlight[-] -nolight\n         -rate sec,perc,line,tot");

	InitThreads ();

	start = I_FloatTime ();

	strcpy (source, argv[i]);
	StripExtension (source);
	DefaultExtension (source, ".bsp");
	
	WriteChk(source);

	LoadBSPFile (source);

	logprintf ("File: %s\n", source);
	
	LoadEntities ();
		
	MakeTnodes (&dmodels[0]);

	LightWorld ();

	WriteEntitiesToString ();	
	WriteBSPFile (source);

	PrintFinish();
	
	return 0;
}

