// cmdlib.h

#ifndef __CMDLIB__
#define __CMDLIB__

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>
#include <time.h>
#include <stdarg.h>

#ifndef __BYTEBOOL__
#define __BYTEBOOL__
typedef enum {false, true} qboolean;
typedef unsigned char byte;
#endif

// the dec offsetof macro doesn't work very well...
#define myoffsetof(type,identifier) ((size_t)&((type *)0)->identifier)


// set these before calling CheckParm
extern int myargc;
extern char **myargv;

char *strupr (char *in);
char *strlower (char *in);
//int Q_strncasecmp (char *s1, char *s2, int n);
//int Q_strcasecmp (char *s1, char *s2);
#define Q_strncasecmp strnicmp
#define Q_strcasecmp stricmp
void Q_getwd (char *out);

int filelength (FILE *f);
int	FileTime (char *path);

void	Q_mkdir (char *path);

extern	char		qdir[1024];
extern	char		gamedir[1024];
void SetQdirFromPath (char *path);
void ShowPercent(char [], int, int);
char *ExpandPath (char *path);
char *ExpandPathAndArchive (char *path);


double I_FloatTime (void);

void	Error (char *error, ...);
int		CheckParm (char *check);

void	WriteChk(char *filename);
FILE	*SafeOpenWrite (char *filename);
FILE	*SafeOpenRead (char *filename);
void	SafeRead (FILE *f, void *buffer, int count);
void	SafeWrite (FILE *f, void *buffer, int count);

int		LoadFile (char *filename, void **bufferptr);
void	SaveFile (char *filename, void *buffer, int count);

void 	DefaultExtension (char *path, char *extension);
void 	DefaultPath (char *path, char *basepath);
void 	StripFilename (char *path);
void 	StripExtension (char *path);

void 	ExtractFilePath (char *path, char *dest);
void 	ExtractFileBase (char *path, char *dest);
void	ExtractFileExtension (char *path, char *dest);

int 	ParseNum (char *str);

short	BigShort (short l);
//short	LittleShort (short l);
#define	LittleShort(a) a
int		BigLong (int l);
//int		LittleLong (int l);
#define	LittleLong(a) a
float	BigFloat (float l);
//float	LittleFloat (float l);
#define	LittleFloat(a) a


char *COM_Parse (char *data);

extern	char		com_token[1024];
extern	qboolean	com_eof;

char *copystring(char *s);


void CRC_Init(unsigned short *crcvalue);
void CRC_ProcessByte(unsigned short *crcvalue, byte data);
unsigned short CRC_Value(unsigned short crcvalue);

void	CreatePath (char *path);
void CopyFile (char *from, char *to);
void SecToStr(time_t, char [], char);
void logprintf (char *fmt, ...);
void logvprintf (char *fmt, va_list argptr);

extern	qboolean archive;
extern	char	 archivedir[1024];

extern	int	 SecRate, PercRate, NewLine, TotTime;

#endif
