
#include "cmdlib.h"
#include "mathlib.h"
#include "bspfile.h"

#define __STDC__ 1 // Kludge
#include "io.h"

void logvprintf (char *fmt, va_list argptr)
{
        vprintf (fmt, argptr);
        fflush(stdout);
}

void logprintf (char *fmt, ...)
{
	va_list argptr;

	va_start (argptr, fmt);
	logvprintf (fmt,argptr);
	va_end (argptr);
}

void PrintFinish (void)
{
}

void main (int argc, char **argv)
{
	struct _finddata_t  FindInfo;
	long		    Handle;
	int		    i, Result;
	char		    source[1024], FullPath[1024], Drv[_MAX_DRIVE], Dir[_MAX_DIR];

	printf ("---- BspInfo 1.11 ---- Modified by Bengt Jardrup\n");

	if (argc == 1)
		Error ("usage: bspinfo bspfile [bspfiles]");
		
	for (i=1 ; i<argc ; i++)
	{
		strcpy (source, argv[i]);
		DefaultExtension (source, ".bsp");

		_splitpath(source, Drv, Dir, NULL, NULL);

		Handle = _findfirst(source, &FindInfo);

		if (Handle == -1L)
			printf("\nWARNING: No match for %s\n", source);
		else
		{
			Result = 0;

			while (Result == 0)
			{
				_makepath(FullPath, Drv, Dir, FindInfo.name, NULL);

				printf ("\n%s\n", FullPath);
				
				LoadBSPFile (FullPath);		
				PrintBSPFileSizes ();

				Result = _findnext(Handle, &FindInfo);
			}
			
			_findclose(Handle);
		}
	}
}
