/*
 * Decompiled with CFR 0.152.
 */
import com.fov120.quake.map.MapTools;
import com.fov120.quake.map.QMap;
import java.io.File;

public class mapcon {
    private static final String version = "1.3.0";
    private static final String[] validModes = new String[]{"-q1", "-q2"};
    private static final String[] validSwitches = new String[]{"-hint", "-skip", "-portals", "-groups", "-chars", "-addpath", "-wadinfo"};
    private static int mode = 0;
    private static File sourceFile;
    private static File targetFile;
    private static boolean removeHintBrushes;
    private static boolean removeSkipBrushes;
    private static boolean removeAreaPortals;
    private static boolean resolveGroups;
    private static boolean convertChars;
    private static boolean addPath;
    private static String path;
    private static boolean removeWadInfo;

    static {
        removeHintBrushes = false;
        removeSkipBrushes = false;
        removeAreaPortals = false;
        resolveGroups = false;
        convertChars = false;
        addPath = false;
        path = "";
        removeWadInfo = false;
    }

    private static final void printHeader() {
        System.out.println();
        System.out.println("===== Map File Converter =====");
        System.out.println("Version 1.3.0");
        System.out.println("Written by Kristian Duske");
        System.out.println("Email: sleepy@fov120.com");
        System.out.println("www  : http://rem.fov120.com/");
        System.out.println("==============================");
        System.out.println();
    }

    private static final void printFooter() {
    }

    private static final void printUsage() {
        System.out.println("Usage:");
        System.out.println("mapcon <mode> [<switches>] <source file> <target file>");
        System.out.println();
        System.out.println("Valid modes:");
        System.out.println("-q1 - convert a Quake 2 map into a Quake 1 map");
        System.out.println("-q2 - convert a Quake 1 map into a Quake 2 map");
        System.out.println();
        System.out.println("Valid switches:");
        System.out.println("-hint - remove hint brushes from the map");
        System.out.println("-skip - remove skip brushes from the map");
        System.out.println("-groups - resolve func_group entities");
        System.out.println("-portals - remove area portals from the map");
        System.out.println("-wadinfo - remove \"wad\" key from worldspawn");
        System.out.println("-chars - convert \"%\" and \"#\" characters to \"*\" characters");
        System.out.println("-addpath <path> - precede all textures with <path>");
    }

    private static final void printError(String errorMessage) {
        System.out.println("====== Error ======");
        System.out.println(errorMessage);
        System.out.println();
    }

    private static final int inArray(String[] array, String value) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static final void checkArguments(String[] args) {
        if (args.length < 3) {
            mapcon.printError("Too few arguments");
            mapcon.printUsage();
            mapcon.printFooter();
            System.exit(1);
        }
        if (mapcon.inArray(validModes, args[0]) == -1) {
            mapcon.printError(String.valueOf(args[0]) + " is not a valid mode");
            mapcon.printUsage();
            mapcon.printFooter();
            System.exit(1);
        }
        int i = 1;
        while (i < args.length - 2) {
            if (mapcon.inArray(validSwitches, args[i]) == -1 && !args[i - 1].equals("-addpath")) {
                mapcon.printError(String.valueOf(args[i]) + " is not a valid switch");
                mapcon.printUsage();
                mapcon.printFooter();
                System.exit(1);
            }
            ++i;
        }
        sourceFile = new File(args[args.length - 2]);
        if (!sourceFile.exists()) {
            mapcon.printError("Source file does not exist");
            mapcon.printFooter();
            System.exit(1);
        }
        targetFile = new File(args[args.length - 1]);
        if (args[0].equals("-q1")) {
            mode = 1;
            System.out.println("Using mode Q2 > Q1");
        }
        if (args[0].equals("-q2")) {
            mode = 2;
            System.out.println("Using mode Q1 > Q2");
        }
        removeHintBrushes = mapcon.inArray(args, "-hint") != -1;
        removeSkipBrushes = mapcon.inArray(args, "-skip") != -1;
        removeAreaPortals = mapcon.inArray(args, "-portals") != -1;
        convertChars = mapcon.inArray(args, "-chars") != -1;
        resolveGroups = mapcon.inArray(args, "-groups") != -1;
        removeWadInfo = mapcon.inArray(args, "-wadinfo") != -1;
        int index = mapcon.inArray(args, "-addpath");
        if (index != -1) {
            addPath = true;
            path = args[index + 1];
        }
    }

    public static final void main(String[] args) {
        mapcon.printHeader();
        mapcon.checkArguments(args);
        QMap map = new QMap();
        map.loadFromFile(sourceFile.getPath());
        if (mode == 1) {
            System.out.println("Removing texture path...");
            MapTools.removeTexturePath(map);
        }
        if (removeHintBrushes) {
            System.out.println("Removing hint brushes...");
            MapTools.removeHintBrushes(map);
        }
        if (removeSkipBrushes) {
            System.out.println("Removing skip brushes...");
            MapTools.removeSkipBrushes(map);
        }
        if (removeAreaPortals) {
            System.out.println("Removing area portals...");
            MapTools.removeAreaPortals(map);
        }
        if (convertChars) {
            System.out.println("Converting special characters...");
            MapTools.convertSpecialCharacters(map);
        }
        if (addPath) {
            System.out.println("Adding texture path \"" + path + "\"...");
            MapTools.addTexturePath(map, path);
        }
        if (removeWadInfo) {
            System.out.println("Removing wad key...");
            MapTools.removeWadInfo(map);
        }
        if (resolveGroups) {
            System.out.println("Resolving groups...");
            MapTools.resolveGroups(map);
        }
        map.saveToFile(targetFile.getPath(), mode);
        map.printStats();
        mapcon.printFooter();
    }
}

