/*
 * Decompiled with CFR 0.152.
 */
package com.fov120.quake.map;

import com.fov120.quake.map.EntityContainer;
import com.fov120.quake.map.MapParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class QMap {
    public static final int MAP_FORMAT_Q1 = 1;
    public static final int MAP_FORMAT_Q2 = 2;
    public EntityContainer entities = new EntityContainer(this);

    public final void printStats() {
        System.out.println();
        System.out.println("====== Stats ======");
        System.out.println("Total entities: " + this.entityCount());
        System.out.println("Total brushes : " + this.brushCount());
        System.out.println("Total faces   : " + this.faceCount());
        System.out.println("Total keys    : " + this.keyCount());
        System.out.println();
    }

    public final int entityCount() {
        return this.entities.size();
    }

    public final int brushCount() {
        int brushCount = 0;
        int i = 0;
        while (i < this.entities.size()) {
            brushCount += this.entities.get(i).brushCount();
            ++i;
        }
        return brushCount;
    }

    public final int faceCount() {
        int faceCount = 0;
        int i = 0;
        while (i < this.entities.size()) {
            faceCount += this.entities.get(i).faceCount();
            ++i;
        }
        return faceCount;
    }

    public final int keyCount() {
        int keyCount = 0;
        int i = 0;
        while (i < this.entities.size()) {
            keyCount += this.entities.get(i).keyCount();
            ++i;
        }
        return keyCount;
    }

    public final String getString(int format) {
        StringBuffer mapStream = new StringBuffer();
        int i = 0;
        while (i < this.entities.size()) {
            mapStream.append(this.entities.get(i).getString(format));
            ++i;
        }
        return mapStream.toString();
    }

    public final void loadFromFile(String filePath) {
        StringBuffer mapStream = new StringBuffer(10000);
        System.out.println("Loading map file...");
        try {
            String line;
            BufferedReader fileReader = new BufferedReader(new FileReader(filePath));
            while ((line = fileReader.readLine()) != null) {
                mapStream.append(line);
                mapStream.append("\n");
            }
            fileReader.close();
        }
        catch (IOException e) {
            System.out.println("Error reading file " + filePath);
        }
        try {
            MapParser mapParser = new MapParser(mapStream.toString(), this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void saveToFile(String filePath, int format) {
        StringBuffer mapStream = new StringBuffer(10000);
        System.out.println("Saving map file...");
        try {
            BufferedWriter fileWriter = new BufferedWriter(new FileWriter(filePath));
            fileWriter.write(this.getString(format));
            fileWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error writing file " + filePath);
        }
    }
}

