/*
 * Decompiled with CFR 0.152.
 */
package com.fov120.quake.map;

import com.fov120.quake.map.Entity;
import com.fov120.quake.map.QMap;

public class MapTools {
    private static final Entity getWorldSpawn(QMap map) {
        Entity worldSpawn = null;
        int i = 0;
        boolean found = false;
        while (i < map.entities.size() && !found) {
            found = map.entities.get(i).className().equals("worldspawn");
            ++i;
        }
        if (found) {
            worldSpawn = map.entities.get(i - 1);
        }
        return worldSpawn;
    }

    public static final void removeHintBrushes(QMap map) {
        int i = 0;
        while (i < map.entities.size()) {
            int j = map.entities.get((int)i).brushes.size() - 1;
            while (j >= 0) {
                int k = 0;
                while (k < map.entities.get((int)i).brushes.get((int)j).faces.size()) {
                    if ((map.entities.get((int)i).brushes.get((int)j).faces.get(k).getSurfaceFlags() & 0x100) == 256) {
                        map.entities.get((int)i).brushes.remove(j);
                        break;
                    }
                    ++k;
                }
                --j;
            }
            ++i;
        }
    }

    public static final void resolveGroups(QMap map) {
        Entity worldSpawn = MapTools.getWorldSpawn(map);
        if (worldSpawn != null) {
            int i = map.entities.size() - 1;
            while (i >= 0) {
                if (map.entities.get(i).className().equals("func_group")) {
                    int j = 0;
                    while (j < map.entities.get((int)i).brushes.size()) {
                        worldSpawn.brushes.add(map.entities.get((int)i).brushes.get(j));
                        ++j;
                    }
                    map.entities.remove(i);
                }
                --i;
            }
        }
    }

    public static final void removeSkipBrushes(QMap map) {
        int i = 0;
        while (i < map.entities.size()) {
            int j = map.entities.get((int)i).brushes.size() - 1;
            while (j >= 0) {
                int k = 0;
                while (k < map.entities.get((int)i).brushes.get((int)j).faces.size()) {
                    if ((map.entities.get((int)i).brushes.get((int)j).faces.get(k).getSurfaceFlags() & 0x200) == 512) {
                        map.entities.get((int)i).brushes.remove(j);
                        break;
                    }
                    ++k;
                }
                --j;
            }
            ++i;
        }
    }

    public static final void removeAreaPortals(QMap map) {
        int i = map.entities.size() - 1;
        while (i >= 0) {
            if (map.entities.get(i).className().equals("func_areaportal")) {
                map.entities.remove(i);
            }
            --i;
        }
    }

    public static final void convertSpecialCharacters(QMap map) {
        int i = 0;
        while (i < map.entities.size()) {
            int j = 0;
            while (j < map.entities.get((int)i).brushes.size()) {
                int k = 0;
                while (k < map.entities.get((int)i).brushes.get((int)j).faces.size()) {
                    String texture = map.entities.get((int)i).brushes.get((int)j).faces.get(k).getTexture();
                    texture = texture.replace('#', '*');
                    texture = texture.replace('%', '*');
                    map.entities.get((int)i).brushes.get((int)j).faces.get(k).setTexture(texture);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void removeWadInfo(QMap map) {
        Entity worldSpawn = MapTools.getWorldSpawn(map);
        if (worldSpawn != null) {
            int i = worldSpawn.keyCount() - 1;
            while (i >= 0) {
                if (worldSpawn.keys.get(i).getName().equals("wad")) {
                    worldSpawn.keys.remove(i);
                }
                --i;
            }
        }
    }

    public static final void removeTexturePath(QMap map) {
        int i = 0;
        while (i < map.entities.size()) {
            int j = 0;
            while (j < map.entities.get((int)i).brushes.size()) {
                int k = 0;
                while (k < map.entities.get((int)i).brushes.get((int)j).faces.size()) {
                    String texture = map.entities.get((int)i).brushes.get((int)j).faces.get(k).getTexture();
                    texture = texture.substring(texture.indexOf(47) + 1);
                    map.entities.get((int)i).brushes.get((int)j).faces.get(k).setTexture(texture);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public static final void addTexturePath(QMap map, String path) {
        int i = 0;
        while (i < map.entities.size()) {
            int j = 0;
            while (j < map.entities.get((int)i).brushes.size()) {
                int k = 0;
                while (k < map.entities.get((int)i).brushes.get((int)j).faces.size()) {
                    String texture = map.entities.get((int)i).brushes.get((int)j).faces.get(k).getTexture();
                    texture = String.valueOf(path) + "/" + texture;
                    map.entities.get((int)i).brushes.get((int)j).faces.get(k).setTexture(texture);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

