/*
 * Decompiled with CFR 0.152.
 */
package com.fov120.quake.map;

import com.fov120.quake.map.Brush;
import com.fov120.quake.map.Entity;
import com.fov120.quake.map.Face;
import com.fov120.quake.map.Key;
import com.fov120.quake.map.QMap;

public class MapParser {
    public static final int TOKEN_TYPE_EOF = 1;
    public static final int TOKEN_TYPE_TEXTURE = 2;
    public static final int TOKEN_TYPE_FIELD = 3;
    public static final int TOKEN_TYPE_NUMBER = 4;
    private int lineNumber = 1;
    private int pos = -1;
    private String mapStream = "";
    private QMap map;
    private char currentChar = '\u0000';
    private char lastChar = '\u0000';
    private char nextChar = '\u0000';
    private int tokenType = 0;
    private StringBuffer tmpBuffer = new StringBuffer();
    private String textureToken = "";
    private String fieldToken = "";
    private double numberToken = 0.0;

    private final void printError(String errorMessage) {
        System.out.println();
        System.out.println("====== Error ======");
        System.out.println(errorMessage);
        System.out.println("Line  : " + this.lineNumber);
        System.out.println("Pos   : " + this.pos);
        System.out.println("cChar : \"" + this.currentChar + "\"");
        System.out.println("tToken: \"" + this.textureToken + "\"");
        System.out.println("fToken: \"" + this.fieldToken + "\"");
        System.out.println("nToken: \"" + this.numberToken + "\"");
        System.out.println("TType : \"" + this.tokenType + "\"");
        this.map.printStats();
        System.out.println();
        System.exit(1);
    }

    public double parseNumber() {
        StringBuffer tmpBuffer = new StringBuffer();
        do {
            tmpBuffer.append(this.currentChar);
        } while (this.getNextChar() != '\u0000' && (Character.isDigit(this.currentChar) || this.currentChar == '-' || this.currentChar == '.'));
        this.getPreviousChar();
        this.tokenType = 4;
        this.textureToken = "";
        this.fieldToken = "";
        this.numberToken = Double.valueOf(tmpBuffer.toString());
        return this.numberToken;
    }

    public final String parseField() {
        StringBuffer tmpBuffer = new StringBuffer();
        this.getNextChar();
        do {
            tmpBuffer.append(this.currentChar);
        } while (this.getNextChar() != '\u0000' && this.currentChar != '\"');
        this.tokenType = 3;
        this.textureToken = "";
        this.fieldToken = tmpBuffer.toString();
        this.numberToken = 0.0;
        return this.fieldToken;
    }

    public final String parseTexture() {
        StringBuffer tmpBuffer = new StringBuffer();
        do {
            tmpBuffer.append(this.currentChar);
        } while (this.getNextChar() != '\u0000' && !Character.isWhitespace(this.currentChar));
        this.getPreviousChar();
        this.tokenType = 2;
        this.textureToken = tmpBuffer.toString();
        this.fieldToken = "";
        this.numberToken = 0.0;
        return this.textureToken;
    }

    private final boolean expect(char expectChar) {
        if (expectChar != this.currentChar) {
            this.printError("Expecting \"" + expectChar + "\"");
        }
        this.lexScan();
        return true;
    }

    private final boolean lookUp(char expectChar) {
        return expectChar == this.currentChar;
    }

    private final char setCharPos(int pos) {
        if (pos < 0 || pos >= this.mapStream.length()) {
            return '\u0000';
        }
        this.pos = pos;
        this.lastChar = this.currentChar;
        this.nextChar = this.pos < this.mapStream.length() - 2 ? this.mapStream.charAt(this.pos + 1) : (char)'\u0000';
        this.currentChar = this.mapStream.charAt(this.pos);
        return this.currentChar;
    }

    private final char getNextChar() {
        return this.setCharPos(++this.pos);
    }

    private final char getPreviousChar() {
        return this.setCharPos(--this.pos);
    }

    private final int lexScan() {
        block9: while (this.getNextChar() != '\u0000') {
            switch (this.currentChar) {
                case '\u0000': {
                    this.getPreviousChar();
                    return 1;
                }
                case '\n': {
                    ++this.lineNumber;
                    break;
                }
                case '\t': {
                    break;
                }
                case ' ': {
                    break;
                }
                case '/': {
                    if (this.getNextChar() != '/') continue block9;
                    while (this.getNextChar() != '\n') {
                    }
                    this.getPreviousChar();
                    break;
                }
                case '\"': {
                    this.parseField();
                    return 3;
                }
                case '-': {
                    this.parseNumber();
                    return 4;
                }
                default: {
                    if (Character.isDigit(this.currentChar)) {
                        this.parseNumber();
                        return 4;
                    }
                    this.parseTexture();
                    return this.currentChar;
                }
            }
        }
        return 1;
    }

    private final void parseKeys(Entity entity) {
        while (this.lexScan() == 3) {
            Key currentKey = entity.keys.add(new Key());
            currentKey.setName(this.fieldToken);
            if (this.lexScan() != 3) {
                this.printError("Error parsing key value");
            }
            currentKey.setValue(this.fieldToken);
        }
    }

    private final void parseFaces(Brush brush) {
        while (this.lookUp('(')) {
            Face currentFace = brush.faces.add(new Face());
            int i = 0;
            while (i < 3) {
                if (!this.lookUp('(')) {
                    this.printError("Expecting \"(\"");
                }
                int j = 0;
                while (j < 3) {
                    this.lexScan();
                    if (this.tokenType != 4) {
                        this.printError("Error parsing face");
                    }
                    currentFace.getPoint(i).set(j, this.numberToken);
                    ++j;
                }
                this.lexScan();
                if (!this.lookUp(')')) {
                    this.printError("Expecting \")\"");
                }
                this.lexScan();
                ++i;
            }
            if (this.tokenType != 2) {
                this.printError("Error parsing face");
            }
            currentFace.setTexture(this.textureToken);
            this.lexScan();
            if (this.tokenType != 4) {
                this.printError("Error parsing face");
            }
            currentFace.setTextureXOffset((int)this.numberToken);
            this.lexScan();
            if (this.tokenType != 4) {
                this.printError("Error parsing face");
            }
            currentFace.setTextureYOffset((int)this.numberToken);
            this.lexScan();
            if (this.tokenType != 4) {
                this.printError("Error parsing face");
            }
            currentFace.setTextureRotate((int)this.numberToken);
            this.lexScan();
            if (this.tokenType != 4) {
                this.printError("Error parsing face");
            }
            currentFace.setTextureXStretch(this.numberToken);
            this.lexScan();
            if (this.tokenType != 4) {
                this.printError("Error parsing face");
            }
            currentFace.setTextureYStretch(this.numberToken);
            this.lexScan();
            if (this.tokenType != 4) continue;
            currentFace.setContentFlags((int)this.numberToken);
            this.lexScan();
            if (this.tokenType != 4) {
                this.printError("Error parsing face");
            }
            currentFace.setSurfaceFlags((int)this.numberToken);
            this.lexScan();
            if (this.tokenType != 4) {
                this.printError("Error parsing face");
            }
            currentFace.setSurfaceValue((int)this.numberToken);
            this.lexScan();
        }
    }

    private final void parseBrushes(Entity entity) {
        while (this.lookUp('{')) {
            this.lexScan();
            Brush currentBrush = entity.brushes.add(new Brush());
            if (!this.lookUp('}')) {
                this.parseFaces(currentBrush);
            }
            this.expect('}');
        }
    }

    private final void parseEntities() {
        this.lexScan();
        while (this.lookUp('{')) {
            Entity currentEntity = this.map.entities.add(new Entity());
            this.parseKeys(currentEntity);
            if (this.lookUp('{')) {
                this.parseBrushes(currentEntity);
            }
            this.expect('}');
        }
    }

    private final void parseStream(String mapStream, QMap map) {
        System.out.println("Parsing map file...");
        this.map = map;
        this.mapStream = new String(mapStream);
        this.parseEntities();
    }

    public MapParser(String mapStream, QMap map) throws Exception {
        this.parseStream(mapStream, map);
    }
}

